<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
	<title><?php echo e(get_option('brand_name', 'Casual Fitness')); ?></title>

	<link rel="icon" href="<?php echo e(logo_url('favicon')); ?>">

	<!-- GOOGLE FONT: SOURCE SANS PRO -->
	<link rel="stylesheet"
		href="https://fonts.googleapis.com/css?family=Source+Sans+Pro:300,400,400i,700&display=fallback">

	<!-- ICHECK BOOTSTRAP -->
	<link href="<?php echo e(asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- FONT AWESOME ICONS -->
	<link href="<?php echo e(asset('plugins/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- THEME STYLE -->
	<link href="<?php echo e(asset('assets/css/adminlte.min.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- TOASTR -->
	<link rel="stylesheet" href="<?php echo e(asset('plugins/toastr/toastr.min.css')); ?>">

	<!-- SELECT2 -->
	<link rel="stylesheet" href="<?php echo e(asset('plugins/select2/css/select2.min.css')); ?>" type="text/css" />
	
	<link rel="stylesheet" href="<?php echo e(asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css')); ?>"
		type="text/css" />

	<!-- TEMPUSDOMINUS BOOTSTRAP 4 -->
	<link rel="stylesheet" href="<?php echo e(asset('plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>"
		type="text/css" />

	<!-- ALL GENERAL STYLES USED THROUGH OUT THE APPLICATION -->
	<link href="<?php echo e(asset('assets/css/general.css')); ?>" rel="stylesheet" type="text/css" />

	<!-- dropzonejs -->
	<link href="<?php echo e(asset('plugins/dropzone/min/dropzone.min.css')); ?>" rel="stylesheet" type="text/css" />

	<?php echo $__env->yieldContent('styles'); ?>
</head>

<body class="hold-transition sidebar-mini text-sm layout-fixed">
	<div class="wrapper">
		<!-- PRELOADER -->
		<div class="preloader flex-column justify-content-center align-items-center">
			<div class="spinner-border text-primary" role="status">
				<span class="sr-only">Loading...</span>
			</div>
		</div>
		<?php if (isset($component)) { $__componentOriginal71c6471fa76ce19017edc287b6f4508c = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.navbar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('navbar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal71c6471fa76ce19017edc287b6f4508c)): ?>
<?php $component = $__componentOriginal71c6471fa76ce19017edc287b6f4508c; ?>
<?php unset($__componentOriginal71c6471fa76ce19017edc287b6f4508c); ?>
<?php endif; ?>
		<?php if (isset($component)) { $__componentOriginal71c6471fa76ce19017edc287b6f4508c = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.sidebar.sidebar','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('sidebar.sidebar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal71c6471fa76ce19017edc287b6f4508c)): ?>
<?php $component = $__componentOriginal71c6471fa76ce19017edc287b6f4508c; ?>
<?php unset($__componentOriginal71c6471fa76ce19017edc287b6f4508c); ?>
<?php endif; ?>
		<?php echo $__env->yieldContent('content'); ?>
		<?php if (isset($component)) { $__componentOriginal71c6471fa76ce19017edc287b6f4508c = $component; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.footer','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('footer'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal71c6471fa76ce19017edc287b6f4508c)): ?>
<?php $component = $__componentOriginal71c6471fa76ce19017edc287b6f4508c; ?>
<?php unset($__componentOriginal71c6471fa76ce19017edc287b6f4508c); ?>
<?php endif; ?>
	</div>
	<!-- LOGOUT DIALOG BOX -->
	<div class="modal fade" id="modal-default">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<h4 class="modal-title"><?php echo e(__('dashboard.logout_title')); ?></h4>
					<button type="button" class="close" data-dismiss="modal" aria-label="Close">
						<span aria-hidden="true">&times;</span>
					</button>
				</div>
				<div class="modal-body">
					<p><?php echo e(__('dashboard.logout_message')); ?></p>
				</div>
				<div class="modal-footer justify-content-between">
					<button type="button" class="btn btn-default" data-dismiss="modal"><?php echo e(__('dashboard.logout_dismiss')); ?></button>
					<form method="POST" action="<?php echo e(route('logout')); ?>">
						<?php echo csrf_field(); ?>
						<a onclick="event.preventDefault(); this.closest('form').submit();" class="btn btn-primary"
							data-widget="logout" href="#" role="button"><?php echo e(__('dashboard.logout')); ?></a>
					</form>
				</div>
			</div>
		</div>
	</div>

	<!-- JQUERY -->
	<script src="<?php echo e(asset('plugins/jquery/jquery.min.js')); ?>"></script>

	<!-- BOOTSTRAP -->
	<script src="<?php echo e(asset('plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

	<!-- ADMINLTE -->
	<script src="<?php echo e(asset('assets/js/adminlte.js')); ?>"></script>

	<!-- TOASTR -->
	<script src="<?php echo e(asset('plugins/toastr/toastr.min.js')); ?>"></script>

	<!-- OPTIONAL SCRIPTS -->
	<script src="<?php echo e(asset('plugins/chart.js/Chart.min.js')); ?>"></script>

	<!-- InputMask -->
	<script src="<?php echo e(asset('plugins/moment/moment.min.js')); ?>"></script>

	<!--  SELECT2 -->
	<script src="<?php echo e(asset('plugins/select2/js/select2.full.min.js')); ?>"></script>

	<!-- DROPZONEJS -->
	<script src="<?php echo e(asset('plugins/dropzone/min/dropzone.min.js')); ?>"></script>

	<!-- TEMPUSDOMINUS BOOTSTRAP 4 -->
	<script src="<?php echo e(asset('plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>

	<!-- DISPLAY MESSAGES -->
	<script type="text/javascript">
		$(function () {
			"use strict";
			// SHOW SUCCESS MESSAGE
			<?php if(Session:: has('success')): ?>
				toastr.success(' <?php echo e(session('success')); ?> ')
			<?php endif; ?>

			// SHOW ERROR MESSAGE
			<?php if(Session:: has('error')): ?>
			toastr.error('<?php echo e(session('error')); ?>')
			<?php endif; ?>
			});
	</script>

	<!-- GENERAL FUNCTION'S USED THROUGHOUT THE APPLICATION -->
	<script src="<?php echo e(asset('assets/js/general.js')); ?>"></script>

	
	<script>
		var imagesPath = '<?php echo e(URL::asset('images')); ?>';
	</script>

	<!-- ADD CUSTOM SCRIPT FOR SPECIFIC FILES -->
	<?php echo $__env->yieldContent('js-script'); ?>
</body>

</html><?php /**PATH /var/www/html/resources/views/layouts/app.blade.php ENDPATH**/ ?>